/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.xml.TagUtil;
import com.aptana.editor.xml.XMLPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;

public class OpenTagCloser
implements VerifyKeyListener {
    private ITextViewer textViewer;

    public OpenTagCloser(ITextViewer textViewer) {
        this.textViewer = textViewer;
    }

    public void install() {
        this.textViewer.getTextWidget().addVerifyKeyListener((VerifyKeyListener)this);
    }

    public void verifyKey(VerifyEvent event) {
        if (!this.isAutoInsertEnabled() || !this.isAutoInsertCharacter(event.character)) {
            return;
        }
        IDocument document = this.textViewer.getDocument();
        Point selection = this.textViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            char c;
            boolean nextIsLessThan = false;
            if (offset < document.getLength() && (c = document.getChar(offset)) == '>') {
                char d;
                char b = document.getChar(offset - 1);
                if (b != '%' && b != '?') {
                    nextIsLessThan = true;
                    event.doit = false;
                    this.textViewer.setSelectedRange(offset + 1, 0);
                } else if (offset + 1 < document.getLength() && (d = document.getChar(offset + 1)) == '>') {
                    nextIsLessThan = true;
                    event.doit = false;
                    this.textViewer.setSelectedRange(offset + 1, 0);
                }
            }
            if (!this.shouldAutoClose(document, offset, event)) {
                return;
            }
            String openTag = this.getOpenTag(document, offset);
            if (openTag == null || this.skipOpenTag(openTag)) {
                return;
            }
            String closeTag = this.getMatchingCloseTag(openTag);
            if (closeTag == null) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            boolean overwrite = openTag.endsWith(">>");
            if (nextIsLessThan) {
                overwrite = true;
                ++offset;
            }
            if (!overwrite) {
                buffer.append(event.character);
            }
            Document copy = new Document(document.get());
            copy.replace(offset, length, buffer.toString());
            if (TagUtil.tagClosed((IDocument)copy, openTag)) {
                return;
            }
            buffer.append(closeTag);
            document.replace(offset, length, buffer.toString());
            if (nextIsLessThan || overwrite) {
                this.textViewer.setSelectedRange(offset, 0);
            } else {
                this.textViewer.setSelectedRange(offset + 1, 0);
            }
            event.doit = false;
        }
        catch (BadLocationException e) {
            XMLPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.aptana.editor.xml", e.getMessage(), (Throwable)e));
        }
    }

    protected boolean shouldAutoClose(IDocument document, int offset, VerifyEvent event) {
        ITypedRegion partition = document.getDocumentPartitioner().getPartition(offset - 1);
        if (partition != null) {
            if (!this.validPartition(partition)) {
                return false;
            }
            try {
                int length = Math.min(partition.getLength(), offset - partition.getOffset());
                String tagContents = document.get(partition.getOffset(), length);
                return !this.inString(tagContents, length);
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)XMLPlugin.getDefault(), (Throwable)e);
            }
        }
        return false;
    }

    protected boolean validPartition(ITypedRegion partition) {
        return "__xml_tag".equals(partition.getType());
    }

    private boolean inString(String tagContents, int length) {
        boolean inString = false;
        int i = 0;
        while (i < length) {
            char c = tagContents.charAt(i);
            switch (c) {
                case '\\': {
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    inString = !inString;
                    break;
                }
            }
            ++i;
        }
        return inString;
    }

    protected boolean skipOpenTag(String openTag) {
        return openTag == null || openTag.startsWith("<!") || openTag.startsWith("<?") || openTag.startsWith("<%");
    }

    private String getMatchingCloseTag(String openTag) {
        String closeTag;
        int index = openTag.indexOf(32);
        if (index == -1) {
            index = openTag.indexOf(62);
        }
        if (!(closeTag = "</" + openTag.substring(1, index)).endsWith(">")) {
            closeTag = String.valueOf(closeTag) + ">";
        }
        return closeTag;
    }

    private String getOpenTag(IDocument document, int offset) throws BadLocationException {
        ITypedRegion partition = document.getPartition(offset - 1);
        int length = Math.min(partition.getLength(), offset - partition.getOffset());
        String tagContents = document.get(partition.getOffset(), length);
        int lessThanIndex = 0;
        boolean inString = false;
        int i = 0;
        while (i < length) {
            char c = tagContents.charAt(i);
            switch (c) {
                case '<': {
                    if (inString) break;
                    lessThanIndex = i;
                    break;
                }
                case '\\': {
                    if (!inString) break;
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    inString = !inString;
                    break;
                }
            }
            ++i;
        }
        String tagName = (tagContents = tagContents.substring(lessThanIndex)).trim();
        if (tagName.startsWith("<")) {
            tagName = tagName.substring(1).trim();
        }
        String sloppyTag = tagName;
        if (tagName.endsWith(">")) {
            tagName = tagName.substring(0, tagName.length() - 1).trim();
        }
        if (tagName.startsWith("/") || tagName.endsWith("/")) {
            return null;
        }
        int spaceIndex = tagName.indexOf(32);
        if (spaceIndex != -1) {
            tagName = tagName.substring(0, spaceIndex);
        }
        if (tagContents.length() == 0 || tagName.length() == 0) {
            return null;
        }
        if (this.isEmptyTagType(document, tagName)) {
            return null;
        }
        return new String("<" + sloppyTag + ">");
    }

    protected boolean isEmptyTagType(IDocument doc, String tagName) {
        return false;
    }

    protected boolean isAutoInsertCharacter(char character) {
        return character == '>';
    }

    protected boolean isAutoInsertEnabled() {
        return true;
    }

    protected ITextViewer getTextViewer() {
        return this.textViewer;
    }
}

